(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      3152,        126]*)
(*NotebookOutlinePosition[      3993,        153]*)
(*  CellTagsIndexPosition[      3949,        149]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
    \(a2 = 1/6; \nk2[x_, s_] := \ x\ s\  - x^2\ s/2\  - \ s^3/6; \n
    a4 = 2*Integrate[Integrate[\((k2[x, s])\)^2, \ {s, 0, x}], \ {x, 0, 1}]
          \)], "Input"],

Cell[BoxData[
    \(17\/630\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(la1 = Sqrt[a2/a4] // N\)], "Input"],

Cell[BoxData[
    \(2.77604431130856132`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(lam1 = \((1/a4)\)^\((1/4)\) // N\)], "Input"],

Cell[BoxData[
    \(2.60766026661103067`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ Another\ way\ *) \n
    Integrate[\((x\ s\  - x^2\ s/2\  - \ s^3/6)\)^2, \ {s, \ 0, x}]\)\)], 
  "Input"],

Cell[BoxData[
    \(x\^5\/3 - \(2\ x\^6\)\/5 + \(38\ x\^7\)\/315\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(a4 = 2*Integrate[%, {x, \ 0, 1}]\)], "Input"],

Cell[BoxData[
    \(17\/630\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Lambda]1 = Sqrt[a2/a4]\)], "Input"],

Cell[BoxData[
    \(\@\(105\/17\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(N[%]\)], "Input"],

Cell[BoxData[
    \(2.48525060873854197`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ By\ \((2.1  .26)\)\ *) \n
    lambda1 = \((1/a4)\)^\((1/4)\) // N\)\)], "Input"],

Cell[BoxData[
    \(2.46730538733062099`\)], "Output"]
}, Open  ]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{520, 509},
WindowMargins->{{150, Automatic}, {Automatic, 11}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 181, 3, 75, "Input"],
Cell[1915, 56, 41, 1, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[1993, 62, 55, 1, 27, "Input"],
Cell[2051, 65, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2142, 71, 65, 1, 27, "Input"],
Cell[2210, 74, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2301, 80, 132, 3, 43, "Input"],
Cell[2436, 85, 78, 1, 44, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2551, 91, 65, 1, 27, "Input"],
Cell[2619, 94, 41, 1, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2697, 100, 57, 1, 27, "Input"],
Cell[2757, 103, 47, 1, 50, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2841, 109, 37, 1, 27, "Input"],
Cell[2881, 112, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2972, 118, 107, 2, 43, "Input"],
Cell[3082, 122, 54, 1, 26, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

